package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSqlInjectionMatchSetsResponse(
    nextMarker: Option[NextMarker] = None,
    sqlInjectionMatchSets: Option[
      Iterable[zio.aws.wafregional.model.SqlInjectionMatchSetSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse = {
    import ListSqlInjectionMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        sqlInjectionMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sqlInjectionMatchSets)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListSqlInjectionMatchSetsResponse.ReadOnly =
    zio.aws.wafregional.model.ListSqlInjectionMatchSetsResponse
      .wrap(buildAwsValue())
}
object ListSqlInjectionMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafregional.model.ListSqlInjectionMatchSetsResponse =
      zio.aws.wafregional.model.ListSqlInjectionMatchSetsResponse(
        nextMarker.map(value => value),
        sqlInjectionMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def sqlInjectionMatchSets: Option[
      List[zio.aws.wafregional.model.SqlInjectionMatchSetSummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getSqlInjectionMatchSets: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.SqlInjectionMatchSetSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("sqlInjectionMatchSets", sqlInjectionMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ) extends zio.aws.wafregional.model.ListSqlInjectionMatchSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val sqlInjectionMatchSets: Option[
      List[zio.aws.wafregional.model.SqlInjectionMatchSetSummary.ReadOnly]
    ] = scala
      .Option(impl.sqlInjectionMatchSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.SqlInjectionMatchSetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ): zio.aws.wafregional.model.ListSqlInjectionMatchSetsResponse.ReadOnly =
    new Wrapper(impl)
}
