package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListIpSetsResponse(
    nextMarker: Option[NextMarker] = None,
    ipSets: Option[Iterable[zio.aws.wafregional.model.IPSetSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListIpSetsResponse = {
    import ListIpSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListIpSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        ipSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipSets)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ListIpSetsResponse.ReadOnly =
    zio.aws.wafregional.model.ListIpSetsResponse.wrap(buildAwsValue())
}
object ListIpSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListIpSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListIpSetsResponse =
      zio.aws.wafregional.model.ListIpSetsResponse(
        nextMarker.map(value => value),
        ipSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def ipSets: Option[List[zio.aws.wafregional.model.IPSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getIpSets: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.IPSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("ipSets", ipSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListIpSetsResponse
  ) extends zio.aws.wafregional.model.ListIpSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val ipSets
        : Option[List[zio.aws.wafregional.model.IPSetSummary.ReadOnly]] = scala
      .Option(impl.ipSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.IPSetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListIpSetsResponse
  ): zio.aws.wafregional.model.ListIpSetsResponse.ReadOnly = new Wrapper(impl)
}
