package zio.aws.wafregional.model
import java.lang.Integer
import zio.aws.wafregional.model.primitives.{
  PaginationLimit,
  NextMarker,
  ResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListActivatedRulesInRuleGroupRequest(
    ruleGroupId: Option[ResourceId] = None,
    nextMarker: Option[NextMarker] = None,
    limit: Option[PaginationLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest = {
    import ListActivatedRulesInRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest
      .builder()
      .optionallyWith(
        ruleGroupId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.ruleGroupId)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListActivatedRulesInRuleGroupRequest.ReadOnly =
    zio.aws.wafregional.model.ListActivatedRulesInRuleGroupRequest
      .wrap(buildAwsValue())
}
object ListActivatedRulesInRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafregional.model.ListActivatedRulesInRuleGroupRequest =
      zio.aws.wafregional.model.ListActivatedRulesInRuleGroupRequest(
        ruleGroupId.map(value => value),
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def ruleGroupId: Option[ResourceId]
    def nextMarker: Option[NextMarker]
    def limit: Option[PaginationLimit]
    def getRuleGroupId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("ruleGroupId", ruleGroupId)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest
  ) extends zio.aws.wafregional.model.ListActivatedRulesInRuleGroupRequest.ReadOnly {
    override val ruleGroupId: Option[ResourceId] = scala
      .Option(impl.ruleGroupId())
      .map(value => zio.aws.wafregional.model.primitives.ResourceId(value))
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val limit: Option[PaginationLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.wafregional.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest
  ): zio.aws.wafregional.model.ListActivatedRulesInRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
