package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteRegexPatternSetResponse(
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetResponse = {
    import DeleteRegexPatternSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.DeleteRegexPatternSetResponse.ReadOnly =
    zio.aws.wafregional.model.DeleteRegexPatternSetResponse
      .wrap(buildAwsValue())
}
object DeleteRegexPatternSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteRegexPatternSetResponse =
      zio.aws.wafregional.model
        .DeleteRegexPatternSetResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetResponse
  ) extends zio.aws.wafregional.model.DeleteRegexPatternSetResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetResponse
  ): zio.aws.wafregional.model.DeleteRegexPatternSetResponse.ReadOnly =
    new Wrapper(impl)
}
