package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSqlInjectionMatchSetResponse(
    sqlInjectionMatchSet: Option[
      zio.aws.wafregional.model.SqlInjectionMatchSet
    ] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse = {
    import CreateSqlInjectionMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse
      .builder()
      .optionallyWith(sqlInjectionMatchSet.map(value => value.buildAwsValue()))(
        _.sqlInjectionMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateSqlInjectionMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.CreateSqlInjectionMatchSetResponse
      .wrap(buildAwsValue())
}
object CreateSqlInjectionMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafregional.model.CreateSqlInjectionMatchSetResponse =
      zio.aws.wafregional.model.CreateSqlInjectionMatchSetResponse(
        sqlInjectionMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def sqlInjectionMatchSet
        : Option[zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getSqlInjectionMatchSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly
    ] = AwsError.unwrapOptionField("sqlInjectionMatchSet", sqlInjectionMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse
  ) extends zio.aws.wafregional.model.CreateSqlInjectionMatchSetResponse.ReadOnly {
    override val sqlInjectionMatchSet
        : Option[zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly] =
      scala
        .Option(impl.sqlInjectionMatchSet())
        .map(value =>
          zio.aws.wafregional.model.SqlInjectionMatchSet.wrap(value)
        )
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse
  ): zio.aws.wafregional.model.CreateSqlInjectionMatchSetResponse.ReadOnly =
    new Wrapper(impl)
}
