package zio.aws.wafregional.model
import scala.jdk.CollectionConverters.*
sealed trait WafOverrideActionType {
  def unwrap: software.amazon.awssdk.services.waf.model.WafOverrideActionType
}
object WafOverrideActionType {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.WafOverrideActionType
  ): zio.aws.wafregional.model.WafOverrideActionType = value match {
    case software.amazon.awssdk.services.waf.model.WafOverrideActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.WafOverrideActionType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.waf.model.WafOverrideActionType.COUNT =>
      val r = COUNT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafregional.model.WafOverrideActionType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.WafOverrideActionType =
      software.amazon.awssdk.services.waf.model.WafOverrideActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.wafregional.model.WafOverrideActionType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.WafOverrideActionType =
      software.amazon.awssdk.services.waf.model.WafOverrideActionType.NONE
  }
  case object COUNT extends zio.aws.wafregional.model.WafOverrideActionType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.WafOverrideActionType =
      software.amazon.awssdk.services.waf.model.WafOverrideActionType.COUNT
  }
}
