package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRegexPatternSetResponse(
    regexPatternSet: Option[zio.aws.wafregional.model.RegexPatternSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRegexPatternSetResponse = {
    import GetRegexPatternSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRegexPatternSetResponse
      .builder()
      .optionallyWith(regexPatternSet.map(value => value.buildAwsValue()))(
        _.regexPatternSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetRegexPatternSetResponse.ReadOnly =
    zio.aws.wafregional.model.GetRegexPatternSetResponse.wrap(buildAwsValue())
}
object GetRegexPatternSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRegexPatternSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetRegexPatternSetResponse =
      zio.aws.wafregional.model.GetRegexPatternSetResponse(
        regexPatternSet.map(value => value.asEditable)
      )
    def regexPatternSet
        : Option[zio.aws.wafregional.model.RegexPatternSet.ReadOnly]
    def getRegexPatternSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafregional.model.RegexPatternSet.ReadOnly
    ] = AwsError.unwrapOptionField("regexPatternSet", regexPatternSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRegexPatternSetResponse
  ) extends zio.aws.wafregional.model.GetRegexPatternSetResponse.ReadOnly {
    override val regexPatternSet
        : Option[zio.aws.wafregional.model.RegexPatternSet.ReadOnly] = scala
      .Option(impl.regexPatternSet())
      .map(value => zio.aws.wafregional.model.RegexPatternSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRegexPatternSetResponse
  ): zio.aws.wafregional.model.GetRegexPatternSetResponse.ReadOnly =
    new Wrapper(impl)
}
