package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GeoMatchSetSummary(
    geoMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GeoMatchSetSummary = {
    import GeoMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GeoMatchSetSummary
      .builder()
      .geoMatchSetId(ResourceId.unwrap(geoMatchSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GeoMatchSetSummary.ReadOnly =
    zio.aws.wafregional.model.GeoMatchSetSummary.wrap(buildAwsValue())
}
object GeoMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GeoMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GeoMatchSetSummary =
      zio.aws.wafregional.model.GeoMatchSetSummary(geoMatchSetId, name)
    def geoMatchSetId: ResourceId
    def name: ResourceName
    def getGeoMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(geoMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSetSummary
  ) extends zio.aws.wafregional.model.GeoMatchSetSummary.ReadOnly {
    override val geoMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.geoMatchSetId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSetSummary
  ): zio.aws.wafregional.model.GeoMatchSetSummary.ReadOnly = new Wrapper(impl)
}
