package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateGeoMatchSetRequest(
    geoMatchSetId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.wafregional.model.GeoMatchSetUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetRequest = {
    import UpdateGeoMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetRequest
      .builder()
      .geoMatchSetId(ResourceId.unwrap(geoMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.UpdateGeoMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.UpdateGeoMatchSetRequest.wrap(buildAwsValue())
}
object UpdateGeoMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.UpdateGeoMatchSetRequest =
      zio.aws.wafregional.model.UpdateGeoMatchSetRequest(
        geoMatchSetId,
        changeToken,
        updates.map { item =>
          item.asEditable
        }
      )
    def geoMatchSetId: ResourceId
    def changeToken: ChangeToken
    def updates: List[zio.aws.wafregional.model.GeoMatchSetUpdate.ReadOnly]
    def getGeoMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(geoMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.GeoMatchSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetRequest
  ) extends zio.aws.wafregional.model.UpdateGeoMatchSetRequest.ReadOnly {
    override val geoMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.geoMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
    override val updates
        : List[zio.aws.wafregional.model.GeoMatchSetUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.GeoMatchSetUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetRequest
  ): zio.aws.wafregional.model.UpdateGeoMatchSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
