package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetGeoMatchSetResponse(
    geoMatchSet: Option[zio.aws.wafregional.model.GeoMatchSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse = {
    import GetGeoMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse
      .builder()
      .optionallyWith(geoMatchSet.map(value => value.buildAwsValue()))(
        _.geoMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetGeoMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.GetGeoMatchSetResponse.wrap(buildAwsValue())
}
object GetGeoMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetGeoMatchSetResponse =
      zio.aws.wafregional.model
        .GetGeoMatchSetResponse(geoMatchSet.map(value => value.asEditable))
    def geoMatchSet: Option[zio.aws.wafregional.model.GeoMatchSet.ReadOnly]
    def getGeoMatchSet
        : ZIO[Any, AwsError, zio.aws.wafregional.model.GeoMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("geoMatchSet", geoMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse
  ) extends zio.aws.wafregional.model.GetGeoMatchSetResponse.ReadOnly {
    override val geoMatchSet
        : Option[zio.aws.wafregional.model.GeoMatchSet.ReadOnly] = scala
      .Option(impl.geoMatchSet())
      .map(value => zio.aws.wafregional.model.GeoMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse
  ): zio.aws.wafregional.model.GetGeoMatchSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
