package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateSizeConstraintSetRequest(
    name: ResourceName,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetRequest = {
    import CreateSizeConstraintSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateSizeConstraintSetRequest.ReadOnly =
    zio.aws.wafregional.model.CreateSizeConstraintSetRequest
      .wrap(buildAwsValue())
}
object CreateSizeConstraintSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateSizeConstraintSetRequest =
      zio.aws.wafregional.model
        .CreateSizeConstraintSetRequest(name, changeToken)
    def name: ResourceName
    def changeToken: ChangeToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetRequest
  ) extends zio.aws.wafregional.model.CreateSizeConstraintSetRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetRequest
  ): zio.aws.wafregional.model.CreateSizeConstraintSetRequest.ReadOnly =
    new Wrapper(impl)
}
