package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceArn, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateWebAclRequest(
    webACLId: ResourceId,
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.AssociateWebAclRequest = {
    import AssociateWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.AssociateWebAclRequest
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.AssociateWebAclRequest.ReadOnly =
    zio.aws.wafregional.model.AssociateWebAclRequest.wrap(buildAwsValue())
}
object AssociateWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.AssociateWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.AssociateWebAclRequest =
      zio.aws.wafregional.model.AssociateWebAclRequest(webACLId, resourceArn)
    def webACLId: ResourceId
    def resourceArn: ResourceArn
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.AssociateWebAclRequest
  ) extends zio.aws.wafregional.model.AssociateWebAclRequest.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.webACLId())
    override val resourceArn: ResourceArn =
      zio.aws.wafregional.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.AssociateWebAclRequest
  ): zio.aws.wafregional.model.AssociateWebAclRequest.ReadOnly = new Wrapper(
    impl
  )
}
