package zio.aws.vpclattice
import zio.prelude.Subtype
import zio.aws.vpclattice.model.primitives.{
  TagValue,
  TagKey,
  ServiceArn,
  SecurityGroupId
}
import java.time.Instant
import zio.aws.vpclattice.model.primitives.AccessLogSubscriptionId.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccessLogDestinationArn extends Subtype[String]
    type AccessLogDestinationArn =
      zio.aws.vpclattice.model.primitives.AccessLogDestinationArn.Type
    object AccessLogSubscriptionArn extends Subtype[String]
    type AccessLogSubscriptionArn =
      zio.aws.vpclattice.model.primitives.AccessLogSubscriptionArn.Type
    object AccessLogSubscriptionId extends Subtype[String]
    type AccessLogSubscriptionId =
      zio.aws.vpclattice.model.primitives.AccessLogSubscriptionId.Type
    object AccessLogSubscriptionIdentifier extends Subtype[String]
    type AccessLogSubscriptionIdentifier =
      zio.aws.vpclattice.model.primitives.AccessLogSubscriptionIdentifier.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.vpclattice.model.primitives.AccountId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.vpclattice.model.primitives.Arn.Type
    object AuthPolicyString extends Subtype[String]
    type AuthPolicyString =
      zio.aws.vpclattice.model.primitives.AuthPolicyString.Type
    object CertificateArn extends Subtype[String]
    type CertificateArn =
      zio.aws.vpclattice.model.primitives.CertificateArn.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.vpclattice.model.primitives.ClientToken.Type
    object FailureCode extends Subtype[String]
    type FailureCode = zio.aws.vpclattice.model.primitives.FailureCode.Type
    object FailureMessage extends Subtype[String]
    type FailureMessage =
      zio.aws.vpclattice.model.primitives.FailureMessage.Type
    object HeaderMatchContains extends Subtype[String]
    type HeaderMatchContains =
      zio.aws.vpclattice.model.primitives.HeaderMatchContains.Type
    object HeaderMatchExact extends Subtype[String]
    type HeaderMatchExact =
      zio.aws.vpclattice.model.primitives.HeaderMatchExact.Type
    object HeaderMatchName extends Subtype[String]
    type HeaderMatchName =
      zio.aws.vpclattice.model.primitives.HeaderMatchName.Type
    object HeaderMatchPrefix extends Subtype[String]
    type HeaderMatchPrefix =
      zio.aws.vpclattice.model.primitives.HeaderMatchPrefix.Type
    object HealthCheckIntervalSeconds extends Subtype[Int]
    type HealthCheckIntervalSeconds =
      zio.aws.vpclattice.model.primitives.HealthCheckIntervalSeconds.Type
    object HealthCheckPath extends Subtype[String]
    type HealthCheckPath =
      zio.aws.vpclattice.model.primitives.HealthCheckPath.Type
    object HealthCheckPort extends Subtype[Int]
    type HealthCheckPort =
      zio.aws.vpclattice.model.primitives.HealthCheckPort.Type
    object HealthCheckTimeoutSeconds extends Subtype[Int]
    type HealthCheckTimeoutSeconds =
      zio.aws.vpclattice.model.primitives.HealthCheckTimeoutSeconds.Type
    object HealthyThresholdCount extends Subtype[Int]
    type HealthyThresholdCount =
      zio.aws.vpclattice.model.primitives.HealthyThresholdCount.Type
    object HttpCodeMatcher extends Subtype[String]
    type HttpCodeMatcher =
      zio.aws.vpclattice.model.primitives.HttpCodeMatcher.Type
    object HttpMethod extends Subtype[String]
    type HttpMethod = zio.aws.vpclattice.model.primitives.HttpMethod.Type
    object HttpStatusCode extends Subtype[Int]
    type HttpStatusCode =
      zio.aws.vpclattice.model.primitives.HttpStatusCode.Type
    object ListenerArn extends Subtype[String]
    type ListenerArn = zio.aws.vpclattice.model.primitives.ListenerArn.Type
    object ListenerId extends Subtype[String]
    type ListenerId = zio.aws.vpclattice.model.primitives.ListenerId.Type
    object ListenerIdentifier extends Subtype[String]
    type ListenerIdentifier =
      zio.aws.vpclattice.model.primitives.ListenerIdentifier.Type
    object ListenerName extends Subtype[String]
    type ListenerName = zio.aws.vpclattice.model.primitives.ListenerName.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.vpclattice.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.vpclattice.model.primitives.NextToken.Type
    object PathMatchExact extends Subtype[String]
    type PathMatchExact =
      zio.aws.vpclattice.model.primitives.PathMatchExact.Type
    object PathMatchPrefix extends Subtype[String]
    type PathMatchPrefix =
      zio.aws.vpclattice.model.primitives.PathMatchPrefix.Type
    object PolicyString extends Subtype[String]
    type PolicyString = zio.aws.vpclattice.model.primitives.PolicyString.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.vpclattice.model.primitives.Port.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.vpclattice.model.primitives.ResourceArn.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.vpclattice.model.primitives.ResourceId.Type
    object ResourceIdentifier extends Subtype[String]
    type ResourceIdentifier =
      zio.aws.vpclattice.model.primitives.ResourceIdentifier.Type
    object RuleArn extends Subtype[String]
    type RuleArn = zio.aws.vpclattice.model.primitives.RuleArn.Type
    object RuleId extends Subtype[String]
    type RuleId = zio.aws.vpclattice.model.primitives.RuleId.Type
    object RuleIdentifier extends Subtype[String]
    type RuleIdentifier =
      zio.aws.vpclattice.model.primitives.RuleIdentifier.Type
    object RuleName extends Subtype[String]
    type RuleName = zio.aws.vpclattice.model.primitives.RuleName.Type
    object RulePriority extends Subtype[Int]
    type RulePriority = zio.aws.vpclattice.model.primitives.RulePriority.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.vpclattice.model.primitives.SecurityGroupId.Type
    object ServiceArn extends Subtype[String]
    type ServiceArn = zio.aws.vpclattice.model.primitives.ServiceArn.Type
    object ServiceCustomDomainName extends Subtype[String]
    type ServiceCustomDomainName =
      zio.aws.vpclattice.model.primitives.ServiceCustomDomainName.Type
    object ServiceId extends Subtype[String]
    type ServiceId = zio.aws.vpclattice.model.primitives.ServiceId.Type
    object ServiceIdentifier extends Subtype[String]
    type ServiceIdentifier =
      zio.aws.vpclattice.model.primitives.ServiceIdentifier.Type
    object ServiceName extends Subtype[String]
    type ServiceName = zio.aws.vpclattice.model.primitives.ServiceName.Type
    object ServiceNetworkArn extends Subtype[String]
    type ServiceNetworkArn =
      zio.aws.vpclattice.model.primitives.ServiceNetworkArn.Type
    object ServiceNetworkId extends Subtype[String]
    type ServiceNetworkId =
      zio.aws.vpclattice.model.primitives.ServiceNetworkId.Type
    object ServiceNetworkIdentifier extends Subtype[String]
    type ServiceNetworkIdentifier =
      zio.aws.vpclattice.model.primitives.ServiceNetworkIdentifier.Type
    object ServiceNetworkName extends Subtype[String]
    type ServiceNetworkName =
      zio.aws.vpclattice.model.primitives.ServiceNetworkName.Type
    object ServiceNetworkServiceAssociationArn extends Subtype[String]
    type ServiceNetworkServiceAssociationArn =
      zio.aws.vpclattice.model.primitives.ServiceNetworkServiceAssociationArn.Type
    object ServiceNetworkServiceAssociationIdentifier extends Subtype[String]
    type ServiceNetworkServiceAssociationIdentifier =
      zio.aws.vpclattice.model.primitives.ServiceNetworkServiceAssociationIdentifier.Type
    object ServiceNetworkVpcAssociationArn extends Subtype[String]
    type ServiceNetworkVpcAssociationArn =
      zio.aws.vpclattice.model.primitives.ServiceNetworkVpcAssociationArn.Type
    object ServiceNetworkVpcAssociationId extends Subtype[String]
    type ServiceNetworkVpcAssociationId =
      zio.aws.vpclattice.model.primitives.ServiceNetworkVpcAssociationId.Type
    object ServiceNetworkVpcAssociationIdentifier extends Subtype[String]
    type ServiceNetworkVpcAssociationIdentifier =
      zio.aws.vpclattice.model.primitives.ServiceNetworkVpcAssociationIdentifier.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.vpclattice.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.vpclattice.model.primitives.TagValue.Type
    object TargetGroupArn extends Subtype[String]
    type TargetGroupArn =
      zio.aws.vpclattice.model.primitives.TargetGroupArn.Type
    object TargetGroupId extends Subtype[String]
    type TargetGroupId = zio.aws.vpclattice.model.primitives.TargetGroupId.Type
    object TargetGroupIdentifier extends Subtype[String]
    type TargetGroupIdentifier =
      zio.aws.vpclattice.model.primitives.TargetGroupIdentifier.Type
    object TargetGroupName extends Subtype[String]
    type TargetGroupName =
      zio.aws.vpclattice.model.primitives.TargetGroupName.Type
    object TargetGroupWeight extends Subtype[Int]
    type TargetGroupWeight =
      zio.aws.vpclattice.model.primitives.TargetGroupWeight.Type
    object TargetIdString extends Subtype[String]
    type TargetIdString =
      zio.aws.vpclattice.model.primitives.TargetIdString.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.vpclattice.model.primitives.Timestamp.Type
    object UnhealthyThresholdCount extends Subtype[Int]
    type UnhealthyThresholdCount =
      zio.aws.vpclattice.model.primitives.UnhealthyThresholdCount.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.vpclattice.model.primitives.VpcId.Type
  }
  type AccessLogSubscriptionList =
    List[zio.aws.vpclattice.model.AccessLogSubscriptionSummary]
  type CreateServiceNetworkVpcAssociationRequestSecurityGroupIdsList =
    List[SecurityGroupId]
  type DeregisterTargetsRequestTargetsList =
    List[zio.aws.vpclattice.model.Target]
  type HeaderMatchList = List[zio.aws.vpclattice.model.HeaderMatch]
  type ListTargetsRequestTargetsList = List[zio.aws.vpclattice.model.Target]
  type ListenerSummaryList = List[zio.aws.vpclattice.model.ListenerSummary]
  type RegisterTargetsRequestTargetsList = List[zio.aws.vpclattice.model.Target]
  type RuleSummaryList = List[zio.aws.vpclattice.model.RuleSummary]
  type RuleUpdateFailureList = List[zio.aws.vpclattice.model.RuleUpdateFailure]
  type RuleUpdateList = List[zio.aws.vpclattice.model.RuleUpdate]
  type RuleUpdateSuccessList = List[zio.aws.vpclattice.model.RuleUpdateSuccess]
  type SecurityGroupList = List[SecurityGroupId]
  type ServiceArnList = List[ServiceArn]
  type ServiceList = List[zio.aws.vpclattice.model.ServiceSummary]
  type ServiceNetworkList = List[zio.aws.vpclattice.model.ServiceNetworkSummary]
  type ServiceNetworkServiceAssociationList =
    List[zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary]
  type ServiceNetworkVpcAssociationList =
    List[zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary]
  type TagKeys = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TargetFailureList = List[zio.aws.vpclattice.model.TargetFailure]
  type TargetGroupList = List[zio.aws.vpclattice.model.TargetGroupSummary]
  type TargetList = List[zio.aws.vpclattice.model.Target]
  type TargetSummaryList = List[zio.aws.vpclattice.model.TargetSummary]
  type UpdateServiceNetworkVpcAssociationRequestSecurityGroupIdsList =
    List[SecurityGroupId]
  type WeightedTargetGroupList =
    List[zio.aws.vpclattice.model.WeightedTargetGroup]
}
