package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  TargetGroupWeight,
  TargetGroupIdentifier
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class WeightedTargetGroup(
    targetGroupIdentifier: TargetGroupIdentifier,
    weight: Optional[TargetGroupWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup = {
    import WeightedTargetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup
      .builder()
      .targetGroupIdentifier(
        TargetGroupIdentifier.unwrap(targetGroupIdentifier): java.lang.String
      )
      .optionallyWith(
        weight.map(value => TargetGroupWeight.unwrap(value): Integer)
      )(_.weight)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.WeightedTargetGroup.ReadOnly =
    zio.aws.vpclattice.model.WeightedTargetGroup.wrap(buildAwsValue())
}
object WeightedTargetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.WeightedTargetGroup =
      zio.aws.vpclattice.model
        .WeightedTargetGroup(targetGroupIdentifier, weight.map(value => value))
    def targetGroupIdentifier: TargetGroupIdentifier
    def weight: Optional[TargetGroupWeight]
    def getTargetGroupIdentifier: ZIO[Any, Nothing, TargetGroupIdentifier] =
      ZIO.succeed(targetGroupIdentifier)
    def getWeight: ZIO[Any, AwsError, TargetGroupWeight] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup
  ) extends zio.aws.vpclattice.model.WeightedTargetGroup.ReadOnly {
    override val targetGroupIdentifier: TargetGroupIdentifier =
      zio.aws.vpclattice.model.primitives
        .TargetGroupIdentifier(impl.targetGroupIdentifier())
    override val weight: Optional[TargetGroupWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.weight())
      .map(value =>
        zio.aws.vpclattice.model.primitives.TargetGroupWeight(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup
  ): zio.aws.vpclattice.model.WeightedTargetGroup.ReadOnly = new Wrapper(impl)
}
