package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  TargetGroupName,
  TargetGroupId,
  TargetGroupArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTargetGroupResponse(
    arn: Optional[TargetGroupArn] = Optional.Absent,
    config: Optional[zio.aws.vpclattice.model.TargetGroupConfig] =
      Optional.Absent,
    id: Optional[TargetGroupId] = Optional.Absent,
    name: Optional[TargetGroupName] = Optional.Absent,
    status: Optional[zio.aws.vpclattice.model.TargetGroupStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.vpclattice.model.TargetGroupType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupResponse = {
    import UpdateTargetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupResponse
      .builder()
      .optionallyWith(
        arn.map(value => TargetGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .optionallyWith(
        id.map(value => TargetGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => TargetGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.UpdateTargetGroupResponse.ReadOnly =
    zio.aws.vpclattice.model.UpdateTargetGroupResponse.wrap(buildAwsValue())
}
object UpdateTargetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.UpdateTargetGroupResponse =
      zio.aws.vpclattice.model.UpdateTargetGroupResponse(
        arn.map(value => value),
        config.map(value => value.asEditable),
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[TargetGroupArn]
    def config: Optional[zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly]
    def id: Optional[TargetGroupId]
    def name: Optional[TargetGroupName]
    def status: Optional[zio.aws.vpclattice.model.TargetGroupStatus]
    def `type`: Optional[zio.aws.vpclattice.model.TargetGroupType]
    def getArn: ZIO[Any, AwsError, TargetGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getConfig: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly
    ] = AwsError.unwrapOptionField("config", config)
    def getId: ZIO[Any, AwsError, TargetGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, TargetGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupResponse
  ) extends zio.aws.vpclattice.model.UpdateTargetGroupResponse.ReadOnly {
    override val arn: Optional[TargetGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupArn(value))
    override val config
        : Optional[zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.config())
        .map(value => zio.aws.vpclattice.model.TargetGroupConfig.wrap(value))
    override val id: Optional[TargetGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupId(value))
    override val name: Optional[TargetGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupName(value))
    override val status: Optional[zio.aws.vpclattice.model.TargetGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.vpclattice.model.TargetGroupStatus.wrap(value))
    override val `type`: Optional[zio.aws.vpclattice.model.TargetGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.vpclattice.model.TargetGroupType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupResponse
  ): zio.aws.vpclattice.model.UpdateTargetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
