package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.TargetGroupIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateTargetGroupRequest(
    healthCheck: zio.aws.vpclattice.model.HealthCheckConfig,
    targetGroupIdentifier: TargetGroupIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest = {
    import UpdateTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest
      .builder()
      .healthCheck(healthCheck.buildAwsValue())
      .targetGroupIdentifier(
        TargetGroupIdentifier.unwrap(targetGroupIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.UpdateTargetGroupRequest.ReadOnly =
    zio.aws.vpclattice.model.UpdateTargetGroupRequest.wrap(buildAwsValue())
}
object UpdateTargetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.UpdateTargetGroupRequest =
      zio.aws.vpclattice.model
        .UpdateTargetGroupRequest(healthCheck.asEditable, targetGroupIdentifier)
    def healthCheck: zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly
    def targetGroupIdentifier: TargetGroupIdentifier
    def getHealthCheck: ZIO[
      Any,
      Nothing,
      zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly
    ] = ZIO.succeed(healthCheck)
    def getTargetGroupIdentifier: ZIO[Any, Nothing, TargetGroupIdentifier] =
      ZIO.succeed(targetGroupIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest
  ) extends zio.aws.vpclattice.model.UpdateTargetGroupRequest.ReadOnly {
    override val healthCheck
        : zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly =
      zio.aws.vpclattice.model.HealthCheckConfig.wrap(impl.healthCheck())
    override val targetGroupIdentifier: TargetGroupIdentifier =
      zio.aws.vpclattice.model.primitives
        .TargetGroupIdentifier(impl.targetGroupIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest
  ): zio.aws.vpclattice.model.UpdateTargetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
