package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceId,
  ServiceArn,
  ServiceCustomDomainName,
  CertificateArn,
  ServiceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServiceResponse(
    arn: Optional[ServiceArn] = Optional.Absent,
    authType: Optional[zio.aws.vpclattice.model.AuthType] = Optional.Absent,
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    customDomainName: Optional[ServiceCustomDomainName] = Optional.Absent,
    id: Optional[ServiceId] = Optional.Absent,
    name: Optional[ServiceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateServiceResponse = {
    import UpdateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceResponse
      .builder()
      .optionallyWith(
        arn.map(value => ServiceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        customDomainName.map(value =>
          ServiceCustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(
        id.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.UpdateServiceResponse.ReadOnly =
    zio.aws.vpclattice.model.UpdateServiceResponse.wrap(buildAwsValue())
}
object UpdateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.UpdateServiceResponse =
      zio.aws.vpclattice.model.UpdateServiceResponse(
        arn.map(value => value),
        authType.map(value => value),
        certificateArn.map(value => value),
        customDomainName.map(value => value),
        id.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[ServiceArn]
    def authType: Optional[zio.aws.vpclattice.model.AuthType]
    def certificateArn: Optional[CertificateArn]
    def customDomainName: Optional[ServiceCustomDomainName]
    def id: Optional[ServiceId]
    def name: Optional[ServiceName]
    def getArn: ZIO[Any, AwsError, ServiceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthType: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCustomDomainName: ZIO[Any, AwsError, ServiceCustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceResponse
  ) extends zio.aws.vpclattice.model.UpdateServiceResponse.ReadOnly {
    override val arn: Optional[ServiceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceArn(value))
    override val authType: Optional[zio.aws.vpclattice.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.vpclattice.model.AuthType.wrap(value))
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.vpclattice.model.primitives.CertificateArn(value))
    override val customDomainName: Optional[ServiceCustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceCustomDomainName(value)
        )
    override val id: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceId(value))
    override val name: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceResponse
  ): zio.aws.vpclattice.model.UpdateServiceResponse.ReadOnly = new Wrapper(impl)
}
