package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{ServiceIdentifier, CertificateArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServiceRequest(
    authType: Optional[zio.aws.vpclattice.model.AuthType] = Optional.Absent,
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    serviceIdentifier: ServiceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest = {
    import UpdateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest
      .builder()
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.UpdateServiceRequest.ReadOnly =
    zio.aws.vpclattice.model.UpdateServiceRequest.wrap(buildAwsValue())
}
object UpdateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.UpdateServiceRequest =
      zio.aws.vpclattice.model.UpdateServiceRequest(
        authType.map(value => value),
        certificateArn.map(value => value),
        serviceIdentifier
      )
    def authType: Optional[zio.aws.vpclattice.model.AuthType]
    def certificateArn: Optional[CertificateArn]
    def serviceIdentifier: ServiceIdentifier
    def getAuthType: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest
  ) extends zio.aws.vpclattice.model.UpdateServiceRequest.ReadOnly {
    override val authType: Optional[zio.aws.vpclattice.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.vpclattice.model.AuthType.wrap(value))
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.vpclattice.model.primitives.CertificateArn(value))
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest
  ): zio.aws.vpclattice.model.UpdateServiceRequest.ReadOnly = new Wrapper(impl)
}
