package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceNetworkVpcAssociationIdentifier,
  SecurityGroupId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceNetworkVpcAssociationRequest(
    securityGroupIds: Iterable[SecurityGroupId],
    serviceNetworkVpcAssociationIdentifier: ServiceNetworkVpcAssociationIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest = {
    import UpdateServiceNetworkVpcAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .serviceNetworkVpcAssociationIdentifier(
        ServiceNetworkVpcAssociationIdentifier.unwrap(
          serviceNetworkVpcAssociationIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest.ReadOnly =
    zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateServiceNetworkVpcAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest =
      zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest(
        securityGroupIds,
        serviceNetworkVpcAssociationIdentifier
      )
    def securityGroupIds: List[SecurityGroupId]
    def serviceNetworkVpcAssociationIdentifier
        : ServiceNetworkVpcAssociationIdentifier
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getServiceNetworkVpcAssociationIdentifier
        : ZIO[Any, Nothing, ServiceNetworkVpcAssociationIdentifier] =
      ZIO.succeed(serviceNetworkVpcAssociationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest
  ) extends zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest.ReadOnly {
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.vpclattice.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val serviceNetworkVpcAssociationIdentifier
        : ServiceNetworkVpcAssociationIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceNetworkVpcAssociationIdentifier(
          impl.serviceNetworkVpcAssociationIdentifier()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest
  ): zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
