package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceNetworkName,
  ServiceNetworkId,
  ServiceNetworkArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServiceNetworkResponse(
    arn: Optional[ServiceNetworkArn] = Optional.Absent,
    authType: Optional[zio.aws.vpclattice.model.AuthType] = Optional.Absent,
    id: Optional[ServiceNetworkId] = Optional.Absent,
    name: Optional[ServiceNetworkName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkResponse = {
    import UpdateServiceNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkResponse
      .builder()
      .optionallyWith(
        arn.map(value => ServiceNetworkArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(
        id.map(value => ServiceNetworkId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ServiceNetworkName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.UpdateServiceNetworkResponse.ReadOnly =
    zio.aws.vpclattice.model.UpdateServiceNetworkResponse.wrap(buildAwsValue())
}
object UpdateServiceNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.UpdateServiceNetworkResponse =
      zio.aws.vpclattice.model.UpdateServiceNetworkResponse(
        arn.map(value => value),
        authType.map(value => value),
        id.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[ServiceNetworkArn]
    def authType: Optional[zio.aws.vpclattice.model.AuthType]
    def id: Optional[ServiceNetworkId]
    def name: Optional[ServiceNetworkName]
    def getArn: ZIO[Any, AwsError, ServiceNetworkArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthType: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getId: ZIO[Any, AwsError, ServiceNetworkId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ServiceNetworkName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkResponse
  ) extends zio.aws.vpclattice.model.UpdateServiceNetworkResponse.ReadOnly {
    override val arn: Optional[ServiceNetworkArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.vpclattice.model.primitives.ServiceNetworkArn(value)
      )
    override val authType: Optional[zio.aws.vpclattice.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.vpclattice.model.AuthType.wrap(value))
    override val id: Optional[ServiceNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceNetworkId(value))
    override val name: Optional[ServiceNetworkName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.vpclattice.model.primitives.ServiceNetworkName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkResponse
  ): zio.aws.vpclattice.model.UpdateServiceNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
