package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.ServiceNetworkIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceNetworkRequest(
    authType: zio.aws.vpclattice.model.AuthType,
    serviceNetworkIdentifier: ServiceNetworkIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest = {
    import UpdateServiceNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest
      .builder()
      .authType(authType.unwrap)
      .serviceNetworkIdentifier(
        ServiceNetworkIdentifier.unwrap(
          serviceNetworkIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.UpdateServiceNetworkRequest.ReadOnly =
    zio.aws.vpclattice.model.UpdateServiceNetworkRequest.wrap(buildAwsValue())
}
object UpdateServiceNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.UpdateServiceNetworkRequest =
      zio.aws.vpclattice.model
        .UpdateServiceNetworkRequest(authType, serviceNetworkIdentifier)
    def authType: zio.aws.vpclattice.model.AuthType
    def serviceNetworkIdentifier: ServiceNetworkIdentifier
    def getAuthType: ZIO[Any, Nothing, zio.aws.vpclattice.model.AuthType] =
      ZIO.succeed(authType)
    def getServiceNetworkIdentifier
        : ZIO[Any, Nothing, ServiceNetworkIdentifier] =
      ZIO.succeed(serviceNetworkIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest
  ) extends zio.aws.vpclattice.model.UpdateServiceNetworkRequest.ReadOnly {
    override val authType: zio.aws.vpclattice.model.AuthType =
      zio.aws.vpclattice.model.AuthType.wrap(impl.authType())
    override val serviceNetworkIdentifier: ServiceNetworkIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceNetworkIdentifier(impl.serviceNetworkIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest
  ): zio.aws.vpclattice.model.UpdateServiceNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
