package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ServiceIdentifier,
  RuleIdentifier,
  RulePriority,
  ListenerIdentifier
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateRuleRequest(
    action: Optional[zio.aws.vpclattice.model.RuleAction] = Optional.Absent,
    listenerIdentifier: ListenerIdentifier,
    `match`: Optional[zio.aws.vpclattice.model.RuleMatch] = Optional.Absent,
    priority: Optional[RulePriority] = Optional.Absent,
    ruleIdentifier: RuleIdentifier,
    serviceIdentifier: ServiceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest = {
    import UpdateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .listenerIdentifier(
        ListenerIdentifier.unwrap(listenerIdentifier): java.lang.String
      )
      .optionallyWith(`match`.map(value => value.buildAwsValue()))(_.`match`)
      .optionallyWith(
        priority.map(value => RulePriority.unwrap(value): Integer)
      )(_.priority)
      .ruleIdentifier(RuleIdentifier.unwrap(ruleIdentifier): java.lang.String)
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.UpdateRuleRequest.ReadOnly =
    zio.aws.vpclattice.model.UpdateRuleRequest.wrap(buildAwsValue())
}
object UpdateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.UpdateRuleRequest =
      zio.aws.vpclattice.model.UpdateRuleRequest(
        action.map(value => value.asEditable),
        listenerIdentifier,
        `match`.map(value => value.asEditable),
        priority.map(value => value),
        ruleIdentifier,
        serviceIdentifier
      )
    def action: Optional[zio.aws.vpclattice.model.RuleAction.ReadOnly]
    def listenerIdentifier: ListenerIdentifier
    def `match`: Optional[zio.aws.vpclattice.model.RuleMatch.ReadOnly]
    def priority: Optional[RulePriority]
    def ruleIdentifier: RuleIdentifier
    def serviceIdentifier: ServiceIdentifier
    def getAction
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getListenerIdentifier: ZIO[Any, Nothing, ListenerIdentifier] =
      ZIO.succeed(listenerIdentifier)
    def getMatch
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.RuleMatch.ReadOnly] =
      AwsError.unwrapOptionField("match", `match`)
    def getPriority: ZIO[Any, AwsError, RulePriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getRuleIdentifier: ZIO[Any, Nothing, RuleIdentifier] =
      ZIO.succeed(ruleIdentifier)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest
  ) extends zio.aws.vpclattice.model.UpdateRuleRequest.ReadOnly {
    override val action
        : Optional[zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.vpclattice.model.RuleAction.wrap(value))
    override val listenerIdentifier: ListenerIdentifier =
      zio.aws.vpclattice.model.primitives
        .ListenerIdentifier(impl.listenerIdentifier())
    override val `match`
        : Optional[zio.aws.vpclattice.model.RuleMatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`match`())
        .map(value => zio.aws.vpclattice.model.RuleMatch.wrap(value))
    override val priority: Optional[RulePriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.vpclattice.model.primitives.RulePriority(value))
    override val ruleIdentifier: RuleIdentifier =
      zio.aws.vpclattice.model.primitives.RuleIdentifier(impl.ruleIdentifier())
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest
  ): zio.aws.vpclattice.model.UpdateRuleRequest.ReadOnly = new Wrapper(impl)
}
