package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceIdentifier,
  ListenerIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateListenerRequest(
    defaultAction: zio.aws.vpclattice.model.RuleAction,
    listenerIdentifier: ListenerIdentifier,
    serviceIdentifier: ServiceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest = {
    import UpdateListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest
      .builder()
      .defaultAction(defaultAction.buildAwsValue())
      .listenerIdentifier(
        ListenerIdentifier.unwrap(listenerIdentifier): java.lang.String
      )
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.UpdateListenerRequest.ReadOnly =
    zio.aws.vpclattice.model.UpdateListenerRequest.wrap(buildAwsValue())
}
object UpdateListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.UpdateListenerRequest =
      zio.aws.vpclattice.model.UpdateListenerRequest(
        defaultAction.asEditable,
        listenerIdentifier,
        serviceIdentifier
      )
    def defaultAction: zio.aws.vpclattice.model.RuleAction.ReadOnly
    def listenerIdentifier: ListenerIdentifier
    def serviceIdentifier: ServiceIdentifier
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getListenerIdentifier: ZIO[Any, Nothing, ListenerIdentifier] =
      ZIO.succeed(listenerIdentifier)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest
  ) extends zio.aws.vpclattice.model.UpdateListenerRequest.ReadOnly {
    override val defaultAction: zio.aws.vpclattice.model.RuleAction.ReadOnly =
      zio.aws.vpclattice.model.RuleAction.wrap(impl.defaultAction())
    override val listenerIdentifier: ListenerIdentifier =
      zio.aws.vpclattice.model.primitives
        .ListenerIdentifier(impl.listenerIdentifier())
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest
  ): zio.aws.vpclattice.model.UpdateListenerRequest.ReadOnly = new Wrapper(impl)
}
