package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  AccessLogDestinationArn,
  ResourceArn,
  AccessLogSubscriptionArn,
  ResourceId,
  AccessLogSubscriptionId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAccessLogSubscriptionResponse(
    arn: AccessLogSubscriptionArn,
    destinationArn: AccessLogDestinationArn,
    id: AccessLogSubscriptionId,
    resourceArn: ResourceArn,
    resourceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionResponse = {
    import UpdateAccessLogSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionResponse
      .builder()
      .arn(AccessLogSubscriptionArn.unwrap(arn): java.lang.String)
      .destinationArn(
        AccessLogDestinationArn.unwrap(destinationArn): java.lang.String
      )
      .id(AccessLogSubscriptionId.unwrap(id): java.lang.String)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.ReadOnly =
    zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse
      .wrap(buildAwsValue())
}
object UpdateAccessLogSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse =
      zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse(
        arn,
        destinationArn,
        id,
        resourceArn,
        resourceId
      )
    def arn: AccessLogSubscriptionArn
    def destinationArn: AccessLogDestinationArn
    def id: AccessLogSubscriptionId
    def resourceArn: ResourceArn
    def resourceId: ResourceId
    def getArn: ZIO[Any, Nothing, AccessLogSubscriptionArn] = ZIO.succeed(arn)
    def getDestinationArn: ZIO[Any, Nothing, AccessLogDestinationArn] =
      ZIO.succeed(destinationArn)
    def getId: ZIO[Any, Nothing, AccessLogSubscriptionId] = ZIO.succeed(id)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionResponse
  ) extends zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.ReadOnly {
    override val arn: AccessLogSubscriptionArn =
      zio.aws.vpclattice.model.primitives.AccessLogSubscriptionArn(impl.arn())
    override val destinationArn: AccessLogDestinationArn =
      zio.aws.vpclattice.model.primitives
        .AccessLogDestinationArn(impl.destinationArn())
    override val id: AccessLogSubscriptionId =
      zio.aws.vpclattice.model.primitives.AccessLogSubscriptionId(impl.id())
    override val resourceArn: ResourceArn =
      zio.aws.vpclattice.model.primitives.ResourceArn(impl.resourceArn())
    override val resourceId: ResourceId =
      zio.aws.vpclattice.model.primitives.ResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionResponse
  ): zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
