package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  AccessLogDestinationArn,
  AccessLogSubscriptionIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAccessLogSubscriptionRequest(
    accessLogSubscriptionIdentifier: AccessLogSubscriptionIdentifier,
    destinationArn: AccessLogDestinationArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest = {
    import UpdateAccessLogSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest
      .builder()
      .accessLogSubscriptionIdentifier(
        AccessLogSubscriptionIdentifier.unwrap(
          accessLogSubscriptionIdentifier
        ): java.lang.String
      )
      .destinationArn(
        AccessLogDestinationArn.unwrap(destinationArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.UpdateAccessLogSubscriptionRequest.ReadOnly =
    zio.aws.vpclattice.model.UpdateAccessLogSubscriptionRequest
      .wrap(buildAwsValue())
}
object UpdateAccessLogSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.UpdateAccessLogSubscriptionRequest =
      zio.aws.vpclattice.model.UpdateAccessLogSubscriptionRequest(
        accessLogSubscriptionIdentifier,
        destinationArn
      )
    def accessLogSubscriptionIdentifier: AccessLogSubscriptionIdentifier
    def destinationArn: AccessLogDestinationArn
    def getAccessLogSubscriptionIdentifier
        : ZIO[Any, Nothing, AccessLogSubscriptionIdentifier] =
      ZIO.succeed(accessLogSubscriptionIdentifier)
    def getDestinationArn: ZIO[Any, Nothing, AccessLogDestinationArn] =
      ZIO.succeed(destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest
  ) extends zio.aws.vpclattice.model.UpdateAccessLogSubscriptionRequest.ReadOnly {
    override val accessLogSubscriptionIdentifier
        : AccessLogSubscriptionIdentifier = zio.aws.vpclattice.model.primitives
      .AccessLogSubscriptionIdentifier(impl.accessLogSubscriptionIdentifier())
    override val destinationArn: AccessLogDestinationArn =
      zio.aws.vpclattice.model.primitives
        .AccessLogDestinationArn(impl.destinationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest
  ): zio.aws.vpclattice.model.UpdateAccessLogSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
