package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.Port
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TargetSummary(
    id: Optional[String] = Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    reasonCode: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.vpclattice.model.TargetStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.TargetSummary = {
    import TargetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.TargetSummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(reasonCode.map(value => value: java.lang.String))(
        _.reasonCode
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.TargetSummary.ReadOnly =
    zio.aws.vpclattice.model.TargetSummary.wrap(buildAwsValue())
}
object TargetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.TargetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.TargetSummary =
      zio.aws.vpclattice.model.TargetSummary(
        id.map(value => value),
        port.map(value => value),
        reasonCode.map(value => value),
        status.map(value => value)
      )
    def id: Optional[String]
    def port: Optional[Port]
    def reasonCode: Optional[String]
    def status: Optional[zio.aws.vpclattice.model.TargetStatus]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getReasonCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getStatus: ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.TargetSummary
  ) extends zio.aws.vpclattice.model.TargetSummary.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.vpclattice.model.primitives.Port(value))
    override val reasonCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reasonCode())
      .map(value => value: String)
    override val status: Optional[zio.aws.vpclattice.model.TargetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.vpclattice.model.TargetStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.TargetSummary
  ): zio.aws.vpclattice.model.TargetSummary.ReadOnly = new Wrapper(impl)
}
