package zio.aws.vpclattice.model
import scala.jdk.CollectionConverters.*
sealed trait TargetGroupType {
  def unwrap: software.amazon.awssdk.services.vpclattice.model.TargetGroupType
}
object TargetGroupType {
  def wrap(
      value: software.amazon.awssdk.services.vpclattice.model.TargetGroupType
  ): zio.aws.vpclattice.model.TargetGroupType = value match {
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupType.IP =>
      val r = IP
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupType.LAMBDA =>
      val r = LAMBDA
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupType.INSTANCE =>
      val r = INSTANCE
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupType.ALB =>
      val r = ALB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.vpclattice.model.TargetGroupType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupType =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupType.UNKNOWN_TO_SDK_VERSION
  }
  case object IP extends zio.aws.vpclattice.model.TargetGroupType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupType =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupType.IP
  }
  case object LAMBDA extends zio.aws.vpclattice.model.TargetGroupType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupType =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupType.LAMBDA
  }
  case object INSTANCE extends zio.aws.vpclattice.model.TargetGroupType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupType =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupType.INSTANCE
  }
  case object ALB extends zio.aws.vpclattice.model.TargetGroupType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupType =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupType.ALB
  }
}
