package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  VpcId,
  ServiceArn,
  Timestamp,
  TargetGroupId,
  Port,
  TargetGroupArn,
  TargetGroupName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TargetGroupSummary(
    arn: Optional[TargetGroupArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    id: Optional[TargetGroupId] = Optional.Absent,
    ipAddressType: Optional[zio.aws.vpclattice.model.IpAddressType] =
      Optional.Absent,
    lambdaEventStructureVersion: Optional[
      zio.aws.vpclattice.model.LambdaEventStructureVersion
    ] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    name: Optional[TargetGroupName] = Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    protocol: Optional[zio.aws.vpclattice.model.TargetGroupProtocol] =
      Optional.Absent,
    serviceArns: Optional[Iterable[ServiceArn]] = Optional.Absent,
    status: Optional[zio.aws.vpclattice.model.TargetGroupStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.vpclattice.model.TargetGroupType] =
      Optional.Absent,
    vpcIdentifier: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.TargetGroupSummary = {
    import TargetGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.TargetGroupSummary
      .builder()
      .optionallyWith(
        arn.map(value => TargetGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        id.map(value => TargetGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(lambdaEventStructureVersion.map(value => value.unwrap))(
        _.lambdaEventStructureVersion
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => TargetGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        serviceArns.map(value =>
          value.map { item =>
            ServiceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.serviceArns)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        vpcIdentifier.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly =
    zio.aws.vpclattice.model.TargetGroupSummary.wrap(buildAwsValue())
}
object TargetGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.TargetGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.TargetGroupSummary =
      zio.aws.vpclattice.model.TargetGroupSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        id.map(value => value),
        ipAddressType.map(value => value),
        lambdaEventStructureVersion.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        port.map(value => value),
        protocol.map(value => value),
        serviceArns.map(value => value),
        status.map(value => value),
        `type`.map(value => value),
        vpcIdentifier.map(value => value)
      )
    def arn: Optional[TargetGroupArn]
    def createdAt: Optional[Timestamp]
    def id: Optional[TargetGroupId]
    def ipAddressType: Optional[zio.aws.vpclattice.model.IpAddressType]
    def lambdaEventStructureVersion
        : Optional[zio.aws.vpclattice.model.LambdaEventStructureVersion]
    def lastUpdatedAt: Optional[Timestamp]
    def name: Optional[TargetGroupName]
    def port: Optional[Port]
    def protocol: Optional[zio.aws.vpclattice.model.TargetGroupProtocol]
    def serviceArns: Optional[List[ServiceArn]]
    def status: Optional[zio.aws.vpclattice.model.TargetGroupStatus]
    def `type`: Optional[zio.aws.vpclattice.model.TargetGroupType]
    def vpcIdentifier: Optional[VpcId]
    def getArn: ZIO[Any, AwsError, TargetGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getId: ZIO[Any, AwsError, TargetGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getLambdaEventStructureVersion: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.LambdaEventStructureVersion
    ] = AwsError.unwrapOptionField(
      "lambdaEventStructureVersion",
      lambdaEventStructureVersion
    )
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, TargetGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getServiceArns: ZIO[Any, AwsError, List[ServiceArn]] =
      AwsError.unwrapOptionField("serviceArns", serviceArns)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpcIdentifier: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcIdentifier", vpcIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.TargetGroupSummary
  ) extends zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly {
    override val arn: Optional[TargetGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupArn(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val id: Optional[TargetGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupId(value))
    override val ipAddressType
        : Optional[zio.aws.vpclattice.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.vpclattice.model.IpAddressType.wrap(value))
    override val lambdaEventStructureVersion
        : Optional[zio.aws.vpclattice.model.LambdaEventStructureVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaEventStructureVersion())
        .map(value =>
          zio.aws.vpclattice.model.LambdaEventStructureVersion.wrap(value)
        )
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val name: Optional[TargetGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupName(value))
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.vpclattice.model.primitives.Port(value))
    override val protocol
        : Optional[zio.aws.vpclattice.model.TargetGroupProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.vpclattice.model.TargetGroupProtocol.wrap(value))
    override val serviceArns: Optional[List[ServiceArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.vpclattice.model.primitives.ServiceArn(item)
        }.toList
      )
    override val status: Optional[zio.aws.vpclattice.model.TargetGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.vpclattice.model.TargetGroupStatus.wrap(value))
    override val `type`: Optional[zio.aws.vpclattice.model.TargetGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.vpclattice.model.TargetGroupType.wrap(value))
    override val vpcIdentifier: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcIdentifier())
      .map(value => zio.aws.vpclattice.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.TargetGroupSummary
  ): zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly = new Wrapper(impl)
}
