package zio.aws.vpclattice.model
import scala.jdk.CollectionConverters.*
sealed trait TargetGroupProtocolVersion {
  def unwrap: software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion
}
object TargetGroupProtocolVersion {
  def wrap(
      value: software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion
  ): zio.aws.vpclattice.model.TargetGroupProtocolVersion = value match {
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion.HTTP1 =>
      val r = HTTP1
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion.HTTP2 =>
      val r = HTTP2
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion.GRPC =>
      val r = GRPC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.vpclattice.model.TargetGroupProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP1
      extends zio.aws.vpclattice.model.TargetGroupProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion.HTTP1
  }
  case object HTTP2
      extends zio.aws.vpclattice.model.TargetGroupProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion.HTTP2
  }
  case object GRPC extends zio.aws.vpclattice.model.TargetGroupProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion.GRPC
  }
}
