package zio.aws.vpclattice.model
import scala.jdk.CollectionConverters.*
sealed trait TargetGroupProtocol {
  def unwrap
      : software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol
}
object TargetGroupProtocol {
  def wrap(
      value: software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol
  ): zio.aws.vpclattice.model.TargetGroupProtocol = value match {
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol.HTTPS =>
      val r = HTTPS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.vpclattice.model.TargetGroupProtocol {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP extends zio.aws.vpclattice.model.TargetGroupProtocol {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol.HTTP
  }
  case object HTTPS extends zio.aws.vpclattice.model.TargetGroupProtocol {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol =
      software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol.HTTPS
  }
}
