package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{VpcId, Port}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TargetGroupConfig(
    healthCheck: Optional[zio.aws.vpclattice.model.HealthCheckConfig] =
      Optional.Absent,
    ipAddressType: Optional[zio.aws.vpclattice.model.IpAddressType] =
      Optional.Absent,
    lambdaEventStructureVersion: Optional[
      zio.aws.vpclattice.model.LambdaEventStructureVersion
    ] = Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    protocol: Optional[zio.aws.vpclattice.model.TargetGroupProtocol] =
      Optional.Absent,
    protocolVersion: Optional[
      zio.aws.vpclattice.model.TargetGroupProtocolVersion
    ] = Optional.Absent,
    vpcIdentifier: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.TargetGroupConfig = {
    import TargetGroupConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.TargetGroupConfig
      .builder()
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(lambdaEventStructureVersion.map(value => value.unwrap))(
        _.lambdaEventStructureVersion
      )
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(protocolVersion.map(value => value.unwrap))(
        _.protocolVersion
      )
      .optionallyWith(
        vpcIdentifier.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly =
    zio.aws.vpclattice.model.TargetGroupConfig.wrap(buildAwsValue())
}
object TargetGroupConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.TargetGroupConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.TargetGroupConfig =
      zio.aws.vpclattice.model.TargetGroupConfig(
        healthCheck.map(value => value.asEditable),
        ipAddressType.map(value => value),
        lambdaEventStructureVersion.map(value => value),
        port.map(value => value),
        protocol.map(value => value),
        protocolVersion.map(value => value),
        vpcIdentifier.map(value => value)
      )
    def healthCheck
        : Optional[zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly]
    def ipAddressType: Optional[zio.aws.vpclattice.model.IpAddressType]
    def lambdaEventStructureVersion
        : Optional[zio.aws.vpclattice.model.LambdaEventStructureVersion]
    def port: Optional[Port]
    def protocol: Optional[zio.aws.vpclattice.model.TargetGroupProtocol]
    def protocolVersion
        : Optional[zio.aws.vpclattice.model.TargetGroupProtocolVersion]
    def vpcIdentifier: Optional[VpcId]
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getLambdaEventStructureVersion: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.LambdaEventStructureVersion
    ] = AwsError.unwrapOptionField(
      "lambdaEventStructureVersion",
      lambdaEventStructureVersion
    )
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getProtocolVersion: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.TargetGroupProtocolVersion
    ] = AwsError.unwrapOptionField("protocolVersion", protocolVersion)
    def getVpcIdentifier: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcIdentifier", vpcIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.TargetGroupConfig
  ) extends zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly {
    override val healthCheck
        : Optional[zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheck())
        .map(value => zio.aws.vpclattice.model.HealthCheckConfig.wrap(value))
    override val ipAddressType
        : Optional[zio.aws.vpclattice.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.vpclattice.model.IpAddressType.wrap(value))
    override val lambdaEventStructureVersion
        : Optional[zio.aws.vpclattice.model.LambdaEventStructureVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaEventStructureVersion())
        .map(value =>
          zio.aws.vpclattice.model.LambdaEventStructureVersion.wrap(value)
        )
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.vpclattice.model.primitives.Port(value))
    override val protocol
        : Optional[zio.aws.vpclattice.model.TargetGroupProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.vpclattice.model.TargetGroupProtocol.wrap(value))
    override val protocolVersion
        : Optional[zio.aws.vpclattice.model.TargetGroupProtocolVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolVersion())
        .map(value =>
          zio.aws.vpclattice.model.TargetGroupProtocolVersion.wrap(value)
        )
    override val vpcIdentifier: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcIdentifier())
      .map(value => zio.aws.vpclattice.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.TargetGroupConfig
  ): zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly = new Wrapper(impl)
}
