package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.Port
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TargetFailure(
    failureCode: Optional[String] = Optional.Absent,
    failureMessage: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    port: Optional[Port] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.TargetFailure = {
    import TargetFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.TargetFailure
      .builder()
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.TargetFailure.ReadOnly =
    zio.aws.vpclattice.model.TargetFailure.wrap(buildAwsValue())
}
object TargetFailure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.TargetFailure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.TargetFailure =
      zio.aws.vpclattice.model.TargetFailure(
        failureCode.map(value => value),
        failureMessage.map(value => value),
        id.map(value => value),
        port.map(value => value)
      )
    def failureCode: Optional[String]
    def failureMessage: Optional[String]
    def id: Optional[String]
    def port: Optional[Port]
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.TargetFailure
  ) extends zio.aws.vpclattice.model.TargetFailure.ReadOnly {
    override val failureCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => value: String)
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.vpclattice.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.TargetFailure
  ): zio.aws.vpclattice.model.TargetFailure.ReadOnly = new Wrapper(impl)
}
