package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{Port, TargetIdString}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Target(
    id: TargetIdString,
    port: Optional[Port] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.Target = {
    import Target.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.Target
      .builder()
      .id(TargetIdString.unwrap(id): java.lang.String)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.Target.ReadOnly =
    zio.aws.vpclattice.model.Target.wrap(buildAwsValue())
}
object Target {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.vpclattice.model.Target] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.Target =
      zio.aws.vpclattice.model.Target(id, port.map(value => value))
    def id: TargetIdString
    def port: Optional[Port]
    def getId: ZIO[Any, Nothing, TargetIdString] = ZIO.succeed(id)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.Target
  ) extends zio.aws.vpclattice.model.Target.ReadOnly {
    override val id: TargetIdString =
      zio.aws.vpclattice.model.primitives.TargetIdString(impl.id())
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.vpclattice.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.Target
  ): zio.aws.vpclattice.model.Target.ReadOnly = new Wrapper(impl)
}
