package zio.aws.vpclattice.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceStatus {
  def unwrap: software.amazon.awssdk.services.vpclattice.model.ServiceStatus
}
object ServiceStatus {
  def wrap(
      value: software.amazon.awssdk.services.vpclattice.model.ServiceStatus
  ): zio.aws.vpclattice.model.ServiceStatus = value match {
    case software.amazon.awssdk.services.vpclattice.model.ServiceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.vpclattice.model.ServiceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.vpclattice.model.ServiceStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.vpclattice.model.ServiceStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.vpclattice.model.ServiceStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.vpclattice.model.ServiceStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.vpclattice.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.ServiceStatus =
      software.amazon.awssdk.services.vpclattice.model.ServiceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.vpclattice.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.ServiceStatus =
      software.amazon.awssdk.services.vpclattice.model.ServiceStatus.ACTIVE
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.vpclattice.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.ServiceStatus =
      software.amazon.awssdk.services.vpclattice.model.ServiceStatus.CREATE_IN_PROGRESS
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.vpclattice.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.ServiceStatus =
      software.amazon.awssdk.services.vpclattice.model.ServiceStatus.DELETE_IN_PROGRESS
  }
  case object CREATE_FAILED extends zio.aws.vpclattice.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.ServiceStatus =
      software.amazon.awssdk.services.vpclattice.model.ServiceStatus.CREATE_FAILED
  }
  case object DELETE_FAILED extends zio.aws.vpclattice.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.ServiceStatus =
      software.amazon.awssdk.services.vpclattice.model.ServiceStatus.DELETE_FAILED
  }
}
