package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ServiceId,
  ServiceArn,
  ServiceNetworkServiceAssociationIdentifier,
  AccountId,
  ServiceNetworkId,
  ServiceCustomDomainName,
  ServiceNetworkArn,
  Timestamp,
  ServiceNetworkServiceAssociationArn,
  ServiceNetworkName,
  ServiceName
}
import scala.jdk.CollectionConverters.*
final case class ServiceNetworkServiceAssociationSummary(
    arn: Optional[ServiceNetworkServiceAssociationArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[AccountId] = Optional.Absent,
    customDomainName: Optional[ServiceCustomDomainName] = Optional.Absent,
    dnsEntry: Optional[zio.aws.vpclattice.model.DnsEntry] = Optional.Absent,
    id: Optional[ServiceNetworkServiceAssociationIdentifier] = Optional.Absent,
    serviceArn: Optional[ServiceArn] = Optional.Absent,
    serviceId: Optional[ServiceId] = Optional.Absent,
    serviceName: Optional[ServiceName] = Optional.Absent,
    serviceNetworkArn: Optional[ServiceNetworkArn] = Optional.Absent,
    serviceNetworkId: Optional[ServiceNetworkId] = Optional.Absent,
    serviceNetworkName: Optional[ServiceNetworkName] = Optional.Absent,
    status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationSummary = {
    import ServiceNetworkServiceAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationSummary
      .builder()
      .optionallyWith(
        arn.map(value =>
          ServiceNetworkServiceAssociationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        customDomainName.map(value =>
          ServiceCustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(dnsEntry.map(value => value.buildAwsValue()))(_.dnsEntry)
      .optionallyWith(
        id.map(value =>
          ServiceNetworkServiceAssociationIdentifier.unwrap(
            value
          ): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        serviceArn.map(value => ServiceArn.unwrap(value): java.lang.String)
      )(_.serviceArn)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceNetworkArn.map(value =>
          ServiceNetworkArn.unwrap(value): java.lang.String
        )
      )(_.serviceNetworkArn)
      .optionallyWith(
        serviceNetworkId.map(value =>
          ServiceNetworkId.unwrap(value): java.lang.String
        )
      )(_.serviceNetworkId)
      .optionallyWith(
        serviceNetworkName.map(value =>
          ServiceNetworkName.unwrap(value): java.lang.String
        )
      )(_.serviceNetworkName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary.ReadOnly =
    zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary
      .wrap(buildAwsValue())
}
object ServiceNetworkServiceAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary =
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        createdBy.map(value => value),
        customDomainName.map(value => value),
        dnsEntry.map(value => value.asEditable),
        id.map(value => value),
        serviceArn.map(value => value),
        serviceId.map(value => value),
        serviceName.map(value => value),
        serviceNetworkArn.map(value => value),
        serviceNetworkId.map(value => value),
        serviceNetworkName.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[ServiceNetworkServiceAssociationArn]
    def createdAt: Optional[Timestamp]
    def createdBy: Optional[AccountId]
    def customDomainName: Optional[ServiceCustomDomainName]
    def dnsEntry: Optional[zio.aws.vpclattice.model.DnsEntry.ReadOnly]
    def id: Optional[ServiceNetworkServiceAssociationIdentifier]
    def serviceArn: Optional[ServiceArn]
    def serviceId: Optional[ServiceId]
    def serviceName: Optional[ServiceName]
    def serviceNetworkArn: Optional[ServiceNetworkArn]
    def serviceNetworkId: Optional[ServiceNetworkId]
    def serviceNetworkName: Optional[ServiceNetworkName]
    def status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ]
    def getArn: ZIO[Any, AwsError, ServiceNetworkServiceAssociationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCustomDomainName: ZIO[Any, AwsError, ServiceCustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getDnsEntry
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.DnsEntry.ReadOnly] =
      AwsError.unwrapOptionField("dnsEntry", dnsEntry)
    def getId: ZIO[Any, AwsError, ServiceNetworkServiceAssociationIdentifier] =
      AwsError.unwrapOptionField("id", id)
    def getServiceArn: ZIO[Any, AwsError, ServiceArn] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceNetworkArn: ZIO[Any, AwsError, ServiceNetworkArn] =
      AwsError.unwrapOptionField("serviceNetworkArn", serviceNetworkArn)
    def getServiceNetworkId: ZIO[Any, AwsError, ServiceNetworkId] =
      AwsError.unwrapOptionField("serviceNetworkId", serviceNetworkId)
    def getServiceNetworkName: ZIO[Any, AwsError, ServiceNetworkName] =
      AwsError.unwrapOptionField("serviceNetworkName", serviceNetworkName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationSummary
  ) extends zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary.ReadOnly {
    override val arn: Optional[ServiceNetworkServiceAssociationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkServiceAssociationArn(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val createdBy: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.vpclattice.model.primitives.AccountId(value))
    override val customDomainName: Optional[ServiceCustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceCustomDomainName(value)
        )
    override val dnsEntry
        : Optional[zio.aws.vpclattice.model.DnsEntry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsEntry())
        .map(value => zio.aws.vpclattice.model.DnsEntry.wrap(value))
    override val id: Optional[ServiceNetworkServiceAssociationIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkServiceAssociationIdentifier(value)
        )
    override val serviceArn: Optional[ServiceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArn())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceArn(value))
    override val serviceId: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceId(value))
    override val serviceName: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceName(value))
    override val serviceNetworkArn: Optional[ServiceNetworkArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNetworkArn())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceNetworkArn(value)
        )
    override val serviceNetworkId: Optional[ServiceNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNetworkId())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceNetworkId(value)
        )
    override val serviceNetworkName: Optional[ServiceNetworkName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNetworkName())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceNetworkName(value)
        )
    override val status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationSummary
  ): zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary.ReadOnly =
    new Wrapper(impl)
}
