package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  RuleIdentifier,
  FailureMessage,
  FailureCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleUpdateFailure(
    failureCode: Optional[FailureCode] = Optional.Absent,
    failureMessage: Optional[FailureMessage] = Optional.Absent,
    ruleIdentifier: Optional[RuleIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.RuleUpdateFailure = {
    import RuleUpdateFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.RuleUpdateFailure
      .builder()
      .optionallyWith(
        failureCode.map(value => FailureCode.unwrap(value): java.lang.String)
      )(_.failureCode)
      .optionallyWith(
        failureMessage.map(value =>
          FailureMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .optionallyWith(
        ruleIdentifier.map(value =>
          RuleIdentifier.unwrap(value): java.lang.String
        )
      )(_.ruleIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.RuleUpdateFailure.ReadOnly =
    zio.aws.vpclattice.model.RuleUpdateFailure.wrap(buildAwsValue())
}
object RuleUpdateFailure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.RuleUpdateFailure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.RuleUpdateFailure =
      zio.aws.vpclattice.model.RuleUpdateFailure(
        failureCode.map(value => value),
        failureMessage.map(value => value),
        ruleIdentifier.map(value => value)
      )
    def failureCode: Optional[FailureCode]
    def failureMessage: Optional[FailureMessage]
    def ruleIdentifier: Optional[RuleIdentifier]
    def getFailureCode: ZIO[Any, AwsError, FailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, FailureMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getRuleIdentifier: ZIO[Any, AwsError, RuleIdentifier] =
      AwsError.unwrapOptionField("ruleIdentifier", ruleIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.RuleUpdateFailure
  ) extends zio.aws.vpclattice.model.RuleUpdateFailure.ReadOnly {
    override val failureCode: Optional[FailureCode] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => zio.aws.vpclattice.model.primitives.FailureCode(value))
    override val failureMessage: Optional[FailureMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureMessage())
        .map(value => zio.aws.vpclattice.model.primitives.FailureMessage(value))
    override val ruleIdentifier: Optional[RuleIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleIdentifier())
        .map(value => zio.aws.vpclattice.model.primitives.RuleIdentifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.RuleUpdateFailure
  ): zio.aws.vpclattice.model.RuleUpdateFailure.ReadOnly = new Wrapper(impl)
}
