package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  RuleArn,
  Timestamp,
  RuleId,
  RuleName,
  RulePriority
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RuleSummary(
    arn: Optional[RuleArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    id: Optional[RuleId] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    name: Optional[RuleName] = Optional.Absent,
    priority: Optional[RulePriority] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.RuleSummary = {
    import RuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.RuleSummary
      .builder()
      .optionallyWith(
        arn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(id.map(value => RuleId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        priority.map(value => RulePriority.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.RuleSummary.ReadOnly =
    zio.aws.vpclattice.model.RuleSummary.wrap(buildAwsValue())
}
object RuleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.RuleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.RuleSummary =
      zio.aws.vpclattice.model.RuleSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        id.map(value => value),
        isDefault.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        priority.map(value => value)
      )
    def arn: Optional[RuleArn]
    def createdAt: Optional[Timestamp]
    def id: Optional[RuleId]
    def isDefault: Optional[Boolean]
    def lastUpdatedAt: Optional[Timestamp]
    def name: Optional[RuleName]
    def priority: Optional[RulePriority]
    def getArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getId: ZIO[Any, AwsError, RuleId] = AwsError.unwrapOptionField("id", id)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, RulePriority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.RuleSummary
  ) extends zio.aws.vpclattice.model.RuleSummary.ReadOnly {
    override val arn: Optional[RuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.RuleArn(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val id: Optional[RuleId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.RuleId(value))
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val name: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.RuleName(value))
    override val priority: Optional[RulePriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.vpclattice.model.primitives.RulePriority(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.RuleSummary
  ): zio.aws.vpclattice.model.RuleSummary.ReadOnly = new Wrapper(impl)
}
