package zio.aws.vpclattice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleMatch(
    httpMatch: Optional[zio.aws.vpclattice.model.HttpMatch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.RuleMatch = {
    import RuleMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.RuleMatch
      .builder()
      .optionallyWith(httpMatch.map(value => value.buildAwsValue()))(
        _.httpMatch
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.RuleMatch.ReadOnly =
    zio.aws.vpclattice.model.RuleMatch.wrap(buildAwsValue())
}
object RuleMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.RuleMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.RuleMatch =
      zio.aws.vpclattice.model
        .RuleMatch(httpMatch.map(value => value.asEditable))
    def httpMatch: Optional[zio.aws.vpclattice.model.HttpMatch.ReadOnly]
    def getHttpMatch
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.HttpMatch.ReadOnly] =
      AwsError.unwrapOptionField("httpMatch", httpMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.RuleMatch
  ) extends zio.aws.vpclattice.model.RuleMatch.ReadOnly {
    override val httpMatch
        : Optional[zio.aws.vpclattice.model.HttpMatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpMatch())
        .map(value => zio.aws.vpclattice.model.HttpMatch.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.RuleMatch
  ): zio.aws.vpclattice.model.RuleMatch.ReadOnly = new Wrapper(impl)
}
