package zio.aws.vpclattice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleAction(
    fixedResponse: Optional[zio.aws.vpclattice.model.FixedResponseAction] =
      Optional.Absent,
    forward: Optional[zio.aws.vpclattice.model.ForwardAction] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.RuleAction = {
    import RuleAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.RuleAction
      .builder()
      .optionallyWith(fixedResponse.map(value => value.buildAwsValue()))(
        _.fixedResponse
      )
      .optionallyWith(forward.map(value => value.buildAwsValue()))(_.forward)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.RuleAction.ReadOnly =
    zio.aws.vpclattice.model.RuleAction.wrap(buildAwsValue())
}
object RuleAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.RuleAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.RuleAction =
      zio.aws.vpclattice.model.RuleAction(
        fixedResponse.map(value => value.asEditable),
        forward.map(value => value.asEditable)
      )
    def fixedResponse
        : Optional[zio.aws.vpclattice.model.FixedResponseAction.ReadOnly]
    def forward: Optional[zio.aws.vpclattice.model.ForwardAction.ReadOnly]
    def getFixedResponse: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.FixedResponseAction.ReadOnly
    ] = AwsError.unwrapOptionField("fixedResponse", fixedResponse)
    def getForward
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.ForwardAction.ReadOnly] =
      AwsError.unwrapOptionField("forward", forward)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.RuleAction
  ) extends zio.aws.vpclattice.model.RuleAction.ReadOnly {
    override val fixedResponse
        : Optional[zio.aws.vpclattice.model.FixedResponseAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fixedResponse())
        .map(value => zio.aws.vpclattice.model.FixedResponseAction.wrap(value))
    override val forward
        : Optional[zio.aws.vpclattice.model.ForwardAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forward())
        .map(value => zio.aws.vpclattice.model.ForwardAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.RuleAction
  ): zio.aws.vpclattice.model.RuleAction.ReadOnly = new Wrapper(impl)
}
