package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.TargetGroupIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterTargetsRequest(
    targetGroupIdentifier: TargetGroupIdentifier,
    targets: Iterable[zio.aws.vpclattice.model.Target]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest = {
    import RegisterTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest
      .builder()
      .targetGroupIdentifier(
        TargetGroupIdentifier.unwrap(targetGroupIdentifier): java.lang.String
      )
      .targets(targets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.RegisterTargetsRequest.ReadOnly =
    zio.aws.vpclattice.model.RegisterTargetsRequest.wrap(buildAwsValue())
}
object RegisterTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.RegisterTargetsRequest =
      zio.aws.vpclattice.model.RegisterTargetsRequest(
        targetGroupIdentifier,
        targets.map { item =>
          item.asEditable
        }
      )
    def targetGroupIdentifier: TargetGroupIdentifier
    def targets: List[zio.aws.vpclattice.model.Target.ReadOnly]
    def getTargetGroupIdentifier: ZIO[Any, Nothing, TargetGroupIdentifier] =
      ZIO.succeed(targetGroupIdentifier)
    def getTargets
        : ZIO[Any, Nothing, List[zio.aws.vpclattice.model.Target.ReadOnly]] =
      ZIO.succeed(targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest
  ) extends zio.aws.vpclattice.model.RegisterTargetsRequest.ReadOnly {
    override val targetGroupIdentifier: TargetGroupIdentifier =
      zio.aws.vpclattice.model.primitives
        .TargetGroupIdentifier(impl.targetGroupIdentifier())
    override val targets: List[zio.aws.vpclattice.model.Target.ReadOnly] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.vpclattice.model.Target.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest
  ): zio.aws.vpclattice.model.RegisterTargetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
