package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{ResourceArn, PolicyString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyRequest(
    policy: PolicyString,
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest
      .builder()
      .policy(PolicyString.unwrap(policy): java.lang.String)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.vpclattice.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.PutResourcePolicyRequest =
      zio.aws.vpclattice.model.PutResourcePolicyRequest(policy, resourceArn)
    def policy: PolicyString
    def resourceArn: ResourceArn
    def getPolicy: ZIO[Any, Nothing, PolicyString] = ZIO.succeed(policy)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest
  ) extends zio.aws.vpclattice.model.PutResourcePolicyRequest.ReadOnly {
    override val policy: PolicyString =
      zio.aws.vpclattice.model.primitives.PolicyString(impl.policy())
    override val resourceArn: ResourceArn =
      zio.aws.vpclattice.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest
  ): zio.aws.vpclattice.model.PutResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
