package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.AuthPolicyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutAuthPolicyResponse(
    policy: Optional[AuthPolicyString] = Optional.Absent,
    state: Optional[zio.aws.vpclattice.model.AuthPolicyState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyResponse = {
    import PutAuthPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => AuthPolicyString.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.PutAuthPolicyResponse.ReadOnly =
    zio.aws.vpclattice.model.PutAuthPolicyResponse.wrap(buildAwsValue())
}
object PutAuthPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.PutAuthPolicyResponse =
      zio.aws.vpclattice.model.PutAuthPolicyResponse(
        policy.map(value => value),
        state.map(value => value)
      )
    def policy: Optional[AuthPolicyString]
    def state: Optional[zio.aws.vpclattice.model.AuthPolicyState]
    def getPolicy: ZIO[Any, AwsError, AuthPolicyString] =
      AwsError.unwrapOptionField("policy", policy)
    def getState: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthPolicyState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyResponse
  ) extends zio.aws.vpclattice.model.PutAuthPolicyResponse.ReadOnly {
    override val policy: Optional[AuthPolicyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.vpclattice.model.primitives.AuthPolicyString(value))
    override val state: Optional[zio.aws.vpclattice.model.AuthPolicyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.vpclattice.model.AuthPolicyState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyResponse
  ): zio.aws.vpclattice.model.PutAuthPolicyResponse.ReadOnly = new Wrapper(impl)
}
