package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ResourceIdentifier,
  AuthPolicyString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutAuthPolicyRequest(
    policy: AuthPolicyString,
    resourceIdentifier: ResourceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest = {
    import PutAuthPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest
      .builder()
      .policy(AuthPolicyString.unwrap(policy): java.lang.String)
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.PutAuthPolicyRequest.ReadOnly =
    zio.aws.vpclattice.model.PutAuthPolicyRequest.wrap(buildAwsValue())
}
object PutAuthPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.PutAuthPolicyRequest =
      zio.aws.vpclattice.model.PutAuthPolicyRequest(policy, resourceIdentifier)
    def policy: AuthPolicyString
    def resourceIdentifier: ResourceIdentifier
    def getPolicy: ZIO[Any, Nothing, AuthPolicyString] = ZIO.succeed(policy)
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest
  ) extends zio.aws.vpclattice.model.PutAuthPolicyRequest.ReadOnly {
    override val policy: AuthPolicyString =
      zio.aws.vpclattice.model.primitives.AuthPolicyString(impl.policy())
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest
  ): zio.aws.vpclattice.model.PutAuthPolicyRequest.ReadOnly = new Wrapper(impl)
}
