package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{PathMatchPrefix, PathMatchExact}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PathMatchType(
    exact: Optional[PathMatchExact] = Optional.Absent,
    prefix: Optional[PathMatchPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.PathMatchType = {
    import PathMatchType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.PathMatchType
      .builder()
      .optionallyWith(
        exact.map(value => PathMatchExact.unwrap(value): java.lang.String)
      )(_.exact)
      .optionallyWith(
        prefix.map(value => PathMatchPrefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.PathMatchType.ReadOnly =
    zio.aws.vpclattice.model.PathMatchType.wrap(buildAwsValue())
}
object PathMatchType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.PathMatchType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.PathMatchType =
      zio.aws.vpclattice.model
        .PathMatchType(exact.map(value => value), prefix.map(value => value))
    def exact: Optional[PathMatchExact]
    def prefix: Optional[PathMatchPrefix]
    def getExact: ZIO[Any, AwsError, PathMatchExact] =
      AwsError.unwrapOptionField("exact", exact)
    def getPrefix: ZIO[Any, AwsError, PathMatchPrefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.PathMatchType
  ) extends zio.aws.vpclattice.model.PathMatchType.ReadOnly {
    override val exact: Optional[PathMatchExact] = zio.aws.core.internal
      .optionalFromNullable(impl.exact())
      .map(value => zio.aws.vpclattice.model.primitives.PathMatchExact(value))
    override val prefix: Optional[PathMatchPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.vpclattice.model.primitives.PathMatchPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.PathMatchType
  ): zio.aws.vpclattice.model.PathMatchType.ReadOnly = new Wrapper(impl)
}
