package zio.aws.vpclattice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PathMatch(
    caseSensitive: Optional[Boolean] = Optional.Absent,
    `match`: zio.aws.vpclattice.model.PathMatchType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.PathMatch = {
    import PathMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.PathMatch
      .builder()
      .optionallyWith(caseSensitive.map(value => value: java.lang.Boolean))(
        _.caseSensitive
      )
      .`match`(`match`.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.PathMatch.ReadOnly =
    zio.aws.vpclattice.model.PathMatch.wrap(buildAwsValue())
}
object PathMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.PathMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.PathMatch =
      zio.aws.vpclattice.model
        .PathMatch(caseSensitive.map(value => value), `match`.asEditable)
    def caseSensitive: Optional[Boolean]
    def `match`: zio.aws.vpclattice.model.PathMatchType.ReadOnly
    def getCaseSensitive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("caseSensitive", caseSensitive)
    def getMatch
        : ZIO[Any, Nothing, zio.aws.vpclattice.model.PathMatchType.ReadOnly] =
      ZIO.succeed(`match`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.PathMatch
  ) extends zio.aws.vpclattice.model.PathMatch.ReadOnly {
    override val caseSensitive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.caseSensitive())
      .map(value => value: Boolean)
    override val `match`: zio.aws.vpclattice.model.PathMatchType.ReadOnly =
      zio.aws.vpclattice.model.PathMatchType.wrap(impl.`match`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.PathMatch
  ): zio.aws.vpclattice.model.PathMatch.ReadOnly = new Wrapper(impl)
}
