package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.HttpCodeMatcher
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Matcher(
    httpCode: Optional[HttpCodeMatcher] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.Matcher = {
    import Matcher.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.Matcher
      .builder()
      .optionallyWith(
        httpCode.map(value => HttpCodeMatcher.unwrap(value): java.lang.String)
      )(_.httpCode)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.Matcher.ReadOnly =
    zio.aws.vpclattice.model.Matcher.wrap(buildAwsValue())
}
object Matcher {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.Matcher
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.Matcher =
      zio.aws.vpclattice.model.Matcher(httpCode.map(value => value))
    def httpCode: Optional[HttpCodeMatcher]
    def getHttpCode: ZIO[Any, AwsError, HttpCodeMatcher] =
      AwsError.unwrapOptionField("httpCode", httpCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.Matcher
  ) extends zio.aws.vpclattice.model.Matcher.ReadOnly {
    override val httpCode: Optional[HttpCodeMatcher] = zio.aws.core.internal
      .optionalFromNullable(impl.httpCode())
      .map(value => zio.aws.vpclattice.model.primitives.HttpCodeMatcher(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.Matcher
  ): zio.aws.vpclattice.model.Matcher.ReadOnly = new Wrapper(impl)
}
