package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  TargetGroupIdentifier,
  NextToken,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTargetsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    targetGroupIdentifier: TargetGroupIdentifier,
    targets: Optional[Iterable[zio.aws.vpclattice.model.Target]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest = {
    import ListTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .targetGroupIdentifier(
        TargetGroupIdentifier.unwrap(targetGroupIdentifier): java.lang.String
      )
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.ListTargetsRequest.ReadOnly =
    zio.aws.vpclattice.model.ListTargetsRequest.wrap(buildAwsValue())
}
object ListTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ListTargetsRequest =
      zio.aws.vpclattice.model.ListTargetsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        targetGroupIdentifier,
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def targetGroupIdentifier: TargetGroupIdentifier
    def targets: Optional[List[zio.aws.vpclattice.model.Target.ReadOnly]]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTargetGroupIdentifier: ZIO[Any, Nothing, TargetGroupIdentifier] =
      ZIO.succeed(targetGroupIdentifier)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.vpclattice.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest
  ) extends zio.aws.vpclattice.model.ListTargetsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.vpclattice.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
    override val targetGroupIdentifier: TargetGroupIdentifier =
      zio.aws.vpclattice.model.primitives
        .TargetGroupIdentifier(impl.targetGroupIdentifier())
    override val targets
        : Optional[List[zio.aws.vpclattice.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.Target.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest
  ): zio.aws.vpclattice.model.ListTargetsRequest.ReadOnly = new Wrapper(impl)
}
