package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTargetGroupsResponse(
    items: Optional[Iterable[zio.aws.vpclattice.model.TargetGroupSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse = {
    import ListTargetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.ListTargetGroupsResponse.ReadOnly =
    zio.aws.vpclattice.model.ListTargetGroupsResponse.wrap(buildAwsValue())
}
object ListTargetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ListTargetGroupsResponse =
      zio.aws.vpclattice.model.ListTargetGroupsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items
        : Optional[List[zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse
  ) extends zio.aws.vpclattice.model.ListTargetGroupsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.TargetGroupSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse
  ): zio.aws.vpclattice.model.ListTargetGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
