package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{VpcId, NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTargetGroupsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    targetGroupType: Optional[zio.aws.vpclattice.model.TargetGroupType] =
      Optional.Absent,
    vpcIdentifier: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest = {
    import ListTargetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(targetGroupType.map(value => value.unwrap))(
        _.targetGroupType
      )
      .optionallyWith(
        vpcIdentifier.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.ListTargetGroupsRequest.ReadOnly =
    zio.aws.vpclattice.model.ListTargetGroupsRequest.wrap(buildAwsValue())
}
object ListTargetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ListTargetGroupsRequest =
      zio.aws.vpclattice.model.ListTargetGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        targetGroupType.map(value => value),
        vpcIdentifier.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def targetGroupType: Optional[zio.aws.vpclattice.model.TargetGroupType]
    def vpcIdentifier: Optional[VpcId]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTargetGroupType
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupType] =
      AwsError.unwrapOptionField("targetGroupType", targetGroupType)
    def getVpcIdentifier: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcIdentifier", vpcIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest
  ) extends zio.aws.vpclattice.model.ListTargetGroupsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.vpclattice.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
    override val targetGroupType
        : Optional[zio.aws.vpclattice.model.TargetGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetGroupType())
        .map(value => zio.aws.vpclattice.model.TargetGroupType.wrap(value))
    override val vpcIdentifier: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcIdentifier())
      .map(value => zio.aws.vpclattice.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest
  ): zio.aws.vpclattice.model.ListTargetGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
