package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListServicesResponse(
    items: Optional[Iterable[zio.aws.vpclattice.model.ServiceSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListServicesResponse = {
    import ListServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListServicesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.ListServicesResponse.ReadOnly =
    zio.aws.vpclattice.model.ListServicesResponse.wrap(buildAwsValue())
}
object ListServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ListServicesResponse =
      zio.aws.vpclattice.model.ListServicesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.vpclattice.model.ServiceSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.vpclattice.model.ServiceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListServicesResponse
  ) extends zio.aws.vpclattice.model.ListServicesResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.vpclattice.model.ServiceSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.ServiceSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListServicesResponse
  ): zio.aws.vpclattice.model.ListServicesResponse.ReadOnly = new Wrapper(impl)
}
